local bpm = 174.377 * GAMESTATE:GetSongOptionsObject("ModsLevel_Current"):MusicRate()
local beat = 60/bpm

local keycount = 4
local timings = {
	{type = 1, row = 3072, beats = 8, lanes = {0, 0, 0, 1}},
	{type = 1, row = 3456, beats = 8, lanes = {0, 0, 1, 0}},
	{type = 1, row = 3840, beats = 14, lanes = {0, 1, 0, 0}},
	{type = 1, row = 4608, beats = 8, lanes = {1, 0, 0, 0}},
	{type = 1, row = 4992, beats = 8, lanes = {0, 1, 0, 0}},
	{type = 1, row = 5376, beats = 16, lanes = {0, 0, 1, 0}},
	
	{type = 1, row = 7680, beats = 8, lanes = {0, 0, 0, 1}},
	{type = 1, row = 8064, beats = 6, lanes = {0, 0, 1, 0}},
	{type = 1, row = 8448, beats = 14, lanes = {0, 1, 0, 0}},
	{type = 1, row = 9216, beats = 8, lanes = {1, 0, 0, 0}},
	{type = 1, row = 9600, beats = 6, lanes = {0, 1, 0, 0}},
	{type = 1, row = 9984, beats = 16, lanes = {0, 0, 1, 0}},
	
	{type = 1, row = 12288, beats = 8, lanes = {0, 0, 0, 1}},
	{type = 1, row = 12672, beats = 6, lanes = {0, 0, 1, 0}},
	{type = 1, row = 13056, beats = 8, lanes = {0, 1, 0, 0}},
	{type = 1, row = 13824, beats = 8, lanes = {0, 0, 0, 1}},
	{type = 1, row = 14208, beats = 6, lanes = {0, 0, 1, 0}},
	{type = 1, row = 14592, beats = 16, lanes = {0, 1, 0, 0}},
	
	{type = 1, row = 16896, beats = 8, lanes = {0, 0, 0, 1}},
	{type = 1, row = 17280, beats = 8, lanes = {0, 0, 1, 0}},
	{type = 1, row = 17664, beats = 16, lanes = {0, 1, 0, 0}},
	
	
	{type = 2, row = 7296, beats = 8, lanes = {0, 1, 0, 0}},
	{type = 3, row = 7680, beats = 0, lanes = {0, 1, 0, 0}},
	{type = 2, row = 7488, beats = 4, lanes = {1, 0, 0, 0}},
	{type = 3, row = 7632, beats = 0, lanes = {1, 0, 0, 0}},
	
	{type = 2, row = 11904, beats = 8, lanes = {0, 1, 0, 0}},
	{type = 3, row = 12288, beats = 0, lanes = {0, 1, 0, 0}},
	{type = 2, row = 12096, beats = 4, lanes = {0, 0, 1, 0}},
	{type = 3, row = 12240, beats = 0, lanes = {0, 0, 1, 0}},
	
	{type = 2, row = 15360, beats = 13.5, lanes = {1, 0, 0, 1}},
	{type = 3, row = 16008, beats = 0, lanes = {1, 0, 0, 1}},
	
	{type = 2, row = 16512, beats = 8, lanes = {0, 1, 0, 0}},
	{type = 3, row = 16896, beats = 0, lanes = {0, 1, 0, 0}},
	{type = 2, row = 16704, beats = 4, lanes = {1, 0, 0, 0}},
	{type = 3, row = 16848, beats = 0, lanes = {1, 0, 0, 0}},
	
	{type = 2, row = 19584, beats = 8, lanes = {0, 0, 1, 0}},
	{type = 3, row = 19968, beats = 0, lanes = {0, 0, 1, 0}},
	{type = 2, row = 19776, beats = 4, lanes = {0, 0, 0, 1}},
	{type = 3, row = 19968, beats = 0, lanes = {0, 0, 0, 1}},
	
	
	{type = 4, row = 16008, beats = 2.5, lanes = {1, 1, 1, 1}},
	
	
	{type = 5, row = 19776, beats = 4, lanes = {1, 1, 1, 1}},
	
	--{type = 6, row = {0, 19776}, beats = 0.25, lanes = {1, 1, 1, 0}}
}

for i,timing in pairs(timings) do
	if timing.type == 1 then
		local laneout = {0, 0, 0, 0}
		for lane,active in pairs(timing.lanes) do
			laneout[lane] = active == 1 and 0 or 1
		end
		timings[#timings+1] = {type = 6, row = {timing.row, timing.row + timing.beats*196/4}, beats = 0.1875, lanes = laneout}
	end
end

local applyModToLane = function(p1, timing, lane)
	local type = timing.type
	local beats = timing.beats
	
	local columns = p1:GetChild("NoteField"):get_column_actors()

	local a = columns[lane]
	
	if type == 1 then
		
		local t1 = beats/8 * beat
		local t2 = beats/8 * beat
		local t3 = beats/8 * beat * 6
		
		a:rotationy(180)
		
		a:accelerate(t1)
		
		
		a:zoomy(4)
		a:sleep(t2)
		a:decelerate(t3)
		
		a:rotationy(0)
		
		a:zoomy(1)
		
	elseif type == 2 then
		
		a:diffuseblink():effectperiod(beat/8):effectcolor1(color("#000000")):effectcolor2(color("#ffffff"))
		
	elseif type == 3 then
		
		a:stopeffect()
		a:diffuse(color("#ffffff"))
		
	elseif type == 4 then
		
		p1:decelerate(beats*beat)
		--[[if lane < 3 then
			p1:rotationy(180)
		else
			p1:rotationy(-180)
		end]]
		p1:rotationz(360)
		p1:zoomy(0.8)
		
		--p1:accelerate(beats*beat/8)
		--p1:rotationz(0)
		p1:zoomy(1)
		--p1:hurrytweening()
		
	elseif type == 5 then
		
		a:accelerate(beats*beat)
		a:zoomy(0)
		
	elseif type == 6 then
		
		a:finishtweening()
		--a:glowblink():effectperiod(beats*beat/2)--:effectmagnitude(1)
		--a:sleep(beats*beat)
		a:finishtweening()
		
	end
end
local applyMod = function(p1, timing, lane)
	if lane then
		if timing.lanes[lane] == 1 then
			applyModToLane(p1, timing, lane)
		end
	else
		for lane,active in ipairs(timing.lanes) do
			if active == 1 then
				applyModToLane(p1, timing, lane)
			end
		end
	end
end

local t = Def.ActorFrame{}

t.JudgmentMessageCommand = function(self, param)
	local p1 = SCREENMAN:GetTopScreen():GetChild("PlayerP1")
	local row = param.NoteRow
	
	if row then
		for i,timing in pairs(timings) do
			if type(timing.row) == "table" then
				if row >= timing.row[1] and row <= timing.row[2] then
					applyMod(p1, timing, param.FirstTrack+1)
					
				elseif row > timing.row[2] then
					timings[i] = nil
				end
			else
				if row == timing.row then
					applyMod(p1, timing)
					
					timings[i] = nil
				end
			end
		end
	end
end

return t